

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Edit Employee')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
    <div class="erp-table-section employees-module">
        <div class="container-fluid">
            <div class="tab-content order-summary-tab">
                <div class="tab-pane fade show active" id="add-new-supplier">
                    <div class="table-header mt-lg-4">
                        <h4><?php echo e(__('Edit Employee')); ?></h4>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('employees-read')): ?>
                            <a href="<?php echo e(route('employees.index')); ?>" class="add-order-btn rounded-2"><i class="fas fa-plus-circle"></i> <?php echo e(__('Employee List')); ?> </a>
                        <?php endif; ?>
                    </div>
                    <div class="order-form-section">
                        <form action="<?php echo e(route('employees.update', $employee->id)); ?>" method="post" enctype="multipart/form-data" class="ajaxform">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('put'); ?>
                            <div class="row">
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('Name')); ?></label>
                                    <input type="text" name="name" value="<?php echo e($employee->name); ?>" class="form-control" placeholder="Enter Name">
                                </div>
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('Phone Number')); ?></label>
                                    <input type="text" name="phone" value="<?php echo e($employee->phone); ?>" class="form-control" placeholder="Enter Phone Number">
                                </div>
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('Email')); ?></label>
                                    <input type="email" name="email" value="<?php echo e($employee->email); ?>" class="form-control" placeholder="Enter Email">
                                </div>
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('Address')); ?></label>
                                    <input type="text" name="address" value="<?php echo e($employee->address); ?>" class="form-control" placeholder="Enter Address">
                                </div>
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('Gender')); ?></label>
                                    <select name="gender" class="form-control table-select w-100">
                                        <option value=""><?php echo e(__('Select Gender')); ?></option>
                                        <option value="male" <?php if($employee->gender == 'male'): echo 'selected'; endif; ?>><?php echo e(__('Male')); ?></option>
                                        <option value="female" <?php if($employee->gender == 'female'): echo 'selected'; endif; ?>><?php echo e(__('Female')); ?></option>
                                        <option value="other" <?php if($employee->gender == 'other'): echo 'selected'; endif; ?>><?php echo e(__('Other')); ?></option>
                                    </select>
                                </div>
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('Employment Type')); ?></label>
                                    <select name="employee_type" class="form-control table-select w-100">
                                        <option value=""><?php echo e(__('Select Employee Type')); ?></option>
                                        <option value="part_time" <?php if($employee->employee_type == 'part_time'): echo 'selected'; endif; ?>><?php echo e(__('Part time')); ?></option>
                                        <option value="full_time" <?php if($employee->employee_type == 'full_time'): echo 'selected'; endif; ?>><?php echo e(__('Full time')); ?></option>
                                    </select>
                                </div>
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('Birth Date')); ?></label>
                                    <input type="date" name="birth_date" value="<?php echo e($employee->birth_date); ?>" class="form-control">
                                </div>
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('Joining Date')); ?></label>
                                    <input type="date" name="join_date" value="<?php echo e($employee->join_date); ?>" class="form-control">
                                </div>
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('Designation')); ?></label>
                                    <select name="designation_id" required class="form-control table-select w-100">
                                        <option value=""><?php echo e(__('Select Designation')); ?></option>
                                        <?php $__currentLoopData = $designations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $designation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($designation->id); ?>" <?php if($employee->designation_id == $designation->id): echo 'selected'; endif; ?>><?php echo e($designation->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('Salary')); ?></label>
                                    <input type="number" step="any" name="salary" value="<?php echo e($employee->salary); ?>" class="form-control" placeholder="Enter Salary">
                                </div>
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('NID / Passport')); ?></label>
                                    <input type="file" accept="image/*" name="nid_front" class="form-control" placeholder="Enter Salary">
                                </div>
                                <div class="col-lg-4 mt-1">
                                    <label><?php echo e(__('NID / Passport back (Optional)')); ?></label>
                                    <input type="file" accept="image/*" name="nid_back" class="form-control" placeholder="Enter Salary">
                                </div>

                                <div class="col-lg-12">
                                    <div class="button-group text-center mt-3">
                                        <button type="reset" class="theme-btn border-btn m-2"><?php echo e(__('Reset')); ?></button>
                                        <button class="theme-btn m-2 submit-btn"><?php echo e(__('Save')); ?></button>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/employees/edit.blade.php ENDPATH**/ ?>