

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Invoice')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
    <div class="section-container print-wrapper p-0 erp-new-invice">
        <div class="erp-table-section">
            <button class="print-window theme-btn print-btn float-end"><i class="fa fa-print"></i> Print</button>

            <div class="container p-0">
                <?php echo $__env->make('pages.invoice.header',['title' => __('Partial Payment')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <table class="table commercial-invoice text-start table-bordered text-center invoice-two border-0 mt-2"
                   id="erp-table">
                <thead>
                <tr>
                    <th><?php echo e(__('SL.')); ?></th>
                    <th><?php echo e(__('Date')); ?></th>
                    <th><?php echo e(__('Bill No')); ?></th>
                    <th><?php echo e(__('Voucher No')); ?></th>
                    <th><?php echo e(__('Amount')); ?></th>
                    <th><?php echo e(__('Payment Method')); ?></th>
                    <th><?php echo e(__('Received BY')); ?></th>
                    <th><?php echo e(__('Remarks')); ?></th>
                </tr>
                </thead>
                <tbody>
                <?php
                    $amount = 0;
                ?>
                <?php $__empty_1 = true; $__currentLoopData = $vouchers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $voucher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e(formatted_date($voucher->date)); ?></td>
                        <td><?php echo e($voucher->bill_no); ?></td>
                        <td><?php echo e(optional($voucher->income)->category_name ?? optional($voucher->expense)->category_name ?? $voucher->voucher_no ?? $voucher->bill_no); ?></td>
                        <td><?php echo e($voucher->amount); ?></td>
                        <td>
                            <?php if($voucher->payment_method == 'cheque'): ?>
                                Cheque
                            <?php elseif($voucher->payment_method == 'cash'): ?>
                                Cash
                            <?php elseif($voucher->payment_method == 'bank'): ?>
                                Bank
                            <?php elseif($voucher->payment_method == 'party_balance'): ?>
                                Wallet
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($voucher->user->name ?? ''); ?></td>
                        <td><?php echo e($voucher->remarks); ?></td>
                    </tr>
                    <?php
                        $amount += $voucher->amount
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-danger text-center">No data was found!</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
            <?php if($vouchers->isNotEmpty()): ?>
                <h5><b><?php echo e(__('Amount in word')); ?>: </b><?php echo e(amountInWords($amount) . ' dollar'); ?>.</h5>
            <?php endif; ?>
            <div class="signature">
                <p><?php echo e(__('Client Signature')); ?></p>
                <p><?php echo e(__('Authorized Signature')); ?></p>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.blank', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/invoice/partial-payment.blade.php ENDPATH**/ ?>