

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Pay Salary Update')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
    <div class="erp-table-section">
        <div class="container-fluid">
            <div class="tab-content order-summary-tab">
                <div class="tab-pane fade show active" id="add-new-supplier">
                    <div class="table-header mt-lg-4">
                        <h4><?php echo e(__('Pay Salary Update')); ?></h4>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('employees-list')): ?>
                            <a href="<?php echo e(route('salaries.index')); ?>" class="add-order-btn rounded-2">
                                <i class="fas fa-credit-card me-1"></i>
                                <?php echo e(__('Salaries List')); ?>

                            </a>
                        <?php endif; ?>
                    </div>
                    <div class="order-form-section">
                        <form action="<?php echo e(route('salaries.update', $salary->id)); ?>" method="post" enctype="multipart/form-data" class="ajaxform">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('put'); ?>

                            <div class="row">
                                <div class="col-lg-6 mt-1">
                                    <label><?php echo e(__('Select Employee')); ?></label>
                                    <select name="employee_id" required class="form-control table-select w-100 employee_id">
                                        <option value=""><?php echo e(__('Select Employee')); ?></option>
                                        <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php if($salary->employee_id == $employee->id): echo 'selected'; endif; ?> data-salary="<?php echo e($employee->salary); ?>" value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-lg-6 mt-1">
                                    <label><?php echo e(__('Salary Amount')); ?></label>
                                    <input type="number" step="any" name="amount" value="<?php echo e($salary->amount); ?>" class="form-control amount" placeholder="Enter Salary">
                                </div>
                                <div class="col-lg-6 mt-1">
                                    <label><?php echo e(__('Salary Year')); ?></label>
                                    <select name="year" class="form-control table-select w-100">
                                        <?php for($i = 2000; $i < date('Y')+1; $i++): ?>
                                            <option <?php if($i == $salary->year): echo 'selected'; endif; ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                                <div class="col-lg-6 mt-1">
                                    <label><?php echo e(__('Salary Month')); ?></label>
                                    <select name="month" class="form-control table-select w-100">
                                        <option value=""><?php echo e(__('Select month')); ?></option>
                                        <option <?php if($salary->month == 'January'): echo 'selected'; endif; ?> value="January"><?php echo e(__('January')); ?></option>
                                        <option <?php if($salary->month == 'February'): echo 'selected'; endif; ?> value="February"><?php echo e(__('February')); ?></option>
                                        <option <?php if($salary->month == 'March'): echo 'selected'; endif; ?> value="March"><?php echo e(__('March')); ?></option>
                                        <option <?php if($salary->month == 'April'): echo 'selected'; endif; ?> value="April"><?php echo e(__('April')); ?></option>
                                        <option <?php if($salary->month == 'May'): echo 'selected'; endif; ?> value="May"><?php echo e(__('May')); ?></option>
                                        <option <?php if($salary->month == 'June'): echo 'selected'; endif; ?> value="June"><?php echo e(__('June')); ?></option>
                                        <option <?php if($salary->month == 'July'): echo 'selected'; endif; ?> value="July"><?php echo e(__('July')); ?></option>
                                        <option <?php if($salary->month == 'August'): echo 'selected'; endif; ?> value="August"><?php echo e(__('August')); ?></option>
                                        <option <?php if($salary->month == 'September'): echo 'selected'; endif; ?> value="September"><?php echo e(__('September')); ?></option>
                                        <option <?php if($salary->month == 'October'): echo 'selected'; endif; ?> value="October"><?php echo e(__('October')); ?></option>
                                        <option <?php if($salary->month == 'November'): echo 'selected'; endif; ?> value="November"><?php echo e(__('November')); ?> </option>
                                        <option <?php if($salary->month == 'December'): echo 'selected'; endif; ?> value="December"><?php echo e(__('December')); ?> </option>
                                    </select>
                                </div>
                                <div class="col-lg-6 mt-2">
                                    <label class="table-select-lebel"><?php echo e(__('Payment method')); ?></label>
                                    <div class="input-group">
                                        <select name="payment_method" class="form-control credit_payment_method remove-bg-table-select" required>
                                            <option value=""><?php echo e(__('Select Payment Method')); ?></option>
                                            <option <?php if($salary->payment_method == 'cash'): echo 'selected'; endif; ?> value="cash"><?php echo e(__('Cash')); ?></option>
                                            <option <?php if($salary->payment_method == 'bank'): echo 'selected'; endif; ?> value="bank"><?php echo e(__('Bank')); ?></option>
                                            <option <?php if($salary->payment_method == 'cheque'): echo 'selected'; endif; ?> value="cheque"><?php echo e(__('Cheque')); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6 mt-2 bank_cheque_input <?php echo e(in_array($salary->payment_method, ['bank', 'cheque']) ? '' : 'd-none'); ?>">
                                    <label><?php echo e(__('Select Bank')); ?></label>
                                    <select name="bank_id" class="form-control w-100">
                                        <option value="">-<?php echo e(__('Select Bank')); ?>-</option>
                                        <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php if($salary->bank_id == $bank->id): echo 'selected'; endif; ?> value="<?php echo e($bank->id); ?>" ><?php echo e($bank->bank_name .' - '. $bank->account_number); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-lg-6 mt-2 cheque_input <?php echo e($salary->payment_method == 'cheque' ? '' : 'd-none'); ?>"">
                                    <label><?php echo e(__('Cheque No')); ?></label>
                                    <input type="number" name="cheque_no" value="<?php echo e($salary->meta['issue_date'] ?? ''); ?>" class="form-control" placeholder="0202982883" required>
                                </div>
                                <div class="col-sm-4 mt-2 cheque_input <?php echo e($salary->payment_method == 'cheque' ? '' : 'd-none'); ?>"">
                                    <label><?php echo e(__('Issue Date')); ?></label>
                                    <input type="date" name="issue_date" value="<?php echo e(Carbon\Carbon::parse($salary->meta['issue_date'] ?? NULL)->format('Y-m-d')); ?>"  class="form-control datepicker date" required>
                                </div>
                                <div class="col-lg-6 mt-1">
                                    <label><?php echo e(__('Notes')); ?></label>
                                    <input type="text" step="any" name="notes" value="<?php echo e($salary->notes); ?>" class="form-control" placeholder="Enter Note">
                                </div>

                                <div class="col-lg-12">
                                    <div class="button-group text-center mt-3">
                                        <button type="reset" class="theme-btn border-btn m-2"><?php echo e(__('Reset')); ?></button>
                                        <button class="theme-btn m-2 submit-btn"><?php echo e(__('Save')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('assets/js/custom/custom.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/salaries/edit.blade.php ENDPATH**/ ?>