

<?php $__env->startSection('pdf_title'); ?>
    <?php echo e(__('Sales Invoice Reports')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('pdf_content'); ?>
    <table class="styled-table">
        <thead>
        <tr>
            <th><?php echo e(__('SL.')); ?></th>
            <th><?php echo e(__('Date')); ?></th>
            <th><?php echo e(__('Party Name')); ?></th>
            <th><?php echo e(__('Party Type')); ?></th>
            <th><?php echo e(__('Category Name')); ?></th>
            <th><?php echo e(__('Total Bill')); ?></th>
            <th><?php echo e(__('Total Paid')); ?></th>
            <th><?php echo e(__('Total Due')); ?></th>
            <th><?php echo e(__('Status')); ?></th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $income): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($loop->iteration); ?></td>
                <td><?php echo e(formatted_date($income->created_at)); ?></td>
                <td><?php echo e($income->party->name ?? ''); ?></td>
                <td><?php echo e($income->party->type ?? ''); ?></td>
                <td><?php echo e($income->category_name); ?></td>
                <td><b><?php echo e(currency_format($income->total_bill)); ?></b></td>
                <td><b><?php echo e(currency_format($income->total_paid)); ?></b></td>
                <td><b><?php echo e(currency_format($income->total_due)); ?></b></td>
                <td>
                    <div class="badge bg-<?php echo e($income->status == 1 ? 'primary' : 'danger'); ?>">
                        <?php echo e($income->status == 1 ? 'Active' : 'Inactive'); ?>

                    </div>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('pages.pdf.pdf_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/pdf/due_collection_report.blade.php ENDPATH**/ ?>