<?php $__currentLoopData = $vouchers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $voucher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <td><?php echo e($loop->index + 1); ?> <i class="<?php echo e(request('id') == $voucher->id ? 'fas fa-bell text-red' : ''); ?>"></i></td>
        <td><a href="<?php echo e(route('invoices.voucher',$voucher->id)); ?>" target="_blank" class="text-primary"><?php echo e($voucher->bill_no); ?></a></td>
        <td><?php echo e($voucher->voucher_no ?? optional($voucher->income)->category_name); ?></td>
        <td><?php echo e(optional($voucher->user)->name); ?></td>
        <td><?php echo e(optional($voucher->party)->name ?? 'Others'); ?></td>
        <td><?php echo e(formatted_date($voucher->date)); ?></td>
        <td>
            <?php if($voucher->bill_type == 'due_bill'): ?>
            <div class="badge bg-success">
                Due Bill
            </div>
            <?php elseif($voucher->bill_type == 'advance_payment'): ?>
            <div class="badge bg-primary">
                Advance Payment
            </div>
            <?php elseif($voucher->bill_type == 'balance_withdraw'): ?>
            <div class="badge bg-warning">
                Balance Withdraw
            </div>
            <?php endif; ?>
        </td>
        <td>
            <?php if($voucher->payment_method == 'cheque'): ?>
            <div class="badge bg-warning">
                Cheque
            </div>
            <?php elseif($voucher->payment_method == 'cash'): ?>
            <div class="badge bg-success">
                Cash
            </div>
            <?php elseif($voucher->payment_method == 'bank'): ?>
            <div class="badge bg-primary">
                Bank
            </div>
            <?php elseif($voucher->payment_method == 'party_balance'): ?>
            <div class="badge bg-danger">
                Wallet
            </div>
            <?php endif; ?>
        </td>
        <td><b class="text-<?php echo e($voucher->bill_type == 'balance_withdraw' ? 'danger':'success'); ?>"><?php echo e($voucher->bill_type == 'balance_withdraw' ? '-':'+'); ?><?php echo e(currency_format($voucher->amount)); ?></b></td>
        <td class="print-d-none">
            <div class="dropdown table-action">
                <button type="button" data-bs-toggle="dropdown">
                    <i class="far fa-ellipsis-v"></i>
                </button>
                <ul class="dropdown-menu">
                    <li>
                        <a href="<?php echo e(route('invoices.voucher',$voucher->id)); ?>" target="_blank"><i class="fas fa-print"></i>
                            <?php echo e(__('Print')); ?>

                        </a>
                    </li>
                    <?php if(check_permission($voucher->created_at, 'credit-vouchers', $voucher->user_id)): ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('credit-vouchers-update')): ?>
                        <li>
                            <a href="<?php echo e(route('credit-vouchers.edit', $voucher->id)); ?>" class="edit-btn">
                                <i class="fal fa-pencil-alt"></i>
                                <?php echo e(__('Edit')); ?>

                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('credit-vouchers-delete')): ?>
                        <li>
                            <a href="<?php echo e(route('credit-vouchers.destroy', $voucher->id)); ?>" class="confirm-action" data-method="DELETE">
                                <i class="fal fa-trash-alt"></i>
                                <?php echo e(__('Delete')); ?>

                            </a>
                        </li>
                        <?php endif; ?>
                    <?php elseif($voucher->user_id == auth()->id()): ?>
                        <li>
                            <a href="<?php echo e(route('notifications.send-request', ['id' => $voucher->id, 'model' => 'Voucher'])); ?>" class="confirm-action" data-method="GET">
                                <i class="fas fa-exclamation-triangle"></i>
                                <?php echo e(__('Permission Request')); ?>

                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/accounts/general/credit-vouchers/datas.blade.php ENDPATH**/ ?>