

<?php $__env->startSection('pdf_title'); ?>
    <?php echo e(__('Salary List')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('pdf_content'); ?>
    <table class="styled-table">
        <thead>
        <tr>
            <th><?php echo e(__('SL.')); ?></th>
            <th><?php echo e(__('Employee')); ?></th>
            <th><?php echo e(__('Month')); ?></th>
            <th><?php echo e(__('Year')); ?></th>
            <th><?php echo e(__('Salary Amount')); ?></th>
            <th><?php echo e(__('Paid Amount')); ?></th>
            <th><?php echo e(__('Due Salary')); ?></th>
            <th><?php echo e(__('Payment Method')); ?></th>
            <th><?php echo e(__('Pay Date')); ?></th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($loop->iteration); ?></td>
                <td class="text-dark fw-bold"><?php echo e(optional($salary->employee)->name .' - '. optional($salary->employee)->phone); ?></td>
                <td><?php echo e($salary->month); ?></td>
                <td><?php echo e($salary->year); ?></td>
                <td class="text-dark fw-bold"><?php echo e(currency_format(optional($salary->employee)->salary)); ?></td>
                <td class="text-dark fw-bold"><?php echo e(currency_format($salary->amount)); ?></td>
                <td class="text-dark fw-bold"><?php echo e(currency_format($salary->due_salary)); ?></td>
                <td>
                    <?php if($salary->payment_method == 'cash'): ?>
                        Cash
                    <?php elseif($salary->payment_method == 'bank'): ?>
                        Bank
                    <?php elseif($salary->payment_method == 'cheque'): ?>
                        Cheque
                    <?php endif; ?>
                </td>
                <td><?php echo e(formatted_date($salary->created_at)); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('pages.pdf.pdf_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/pdf/salary.blade.php ENDPATH**/ ?>